﻿<?php
	include_once('header.php');
	$leaderboardScores = [];
	$leaderboardScores["scores"] = [];

	$sql1 = "SELECT id, name, token, reverse FROM leaderboards WHERE id = ?";
	
	if ($stmt = $user_home->prepareQuery($sql1)) {
		$stmt->bind_param('i', $_GET['id']);
		$stmt->execute();

		$stmt->store_result();
		$stmt->bind_result($leaderboardID, $leaderboardName, $leaderboardToken, $leaderboardReverse);
		$stmt->fetch();

		if ($stmt->num_rows == 1) {
			$leaderboardScores["name"] = $leaderboardName;
			$leaderboardScores["id"] = $leaderboardID;
		} else {
            
		}
		$stmt->free_result();
		switch($leaderboardReverse) {
			case 1:
				$reverse = 'ASC';
				break;
			case 0:
				$reverse = 'DESC';
				break;
		}
	}
	
	$sql2 = "SELECT score, user_id, name, add_datetime FROM {$leaderboardToken}_scores WHERE table_id=? ORDER BY score $reverse";
	if ($stmt = $user_home->prepareQuery($sql2)) {
		$stmt->bind_param('i', $_GET['id']);
		$stmt->execute();
		$stmt->bind_result($score, $userID, $name, $date);
		while ($stmt->fetch()) {
			$leaderboardScores["scores"][] = array("score" => $score, "userID" => $userID, "name" => $name, "date" => $date);
		}
	}
?>
	<div id="message" style="display:none;">
		<div class="" id="alert">
			
		</div>
	</div>
      <div class="row">
			<div class="col-12">
				<div class="widget widget-table">
					<div class="widget-header"> <i class="icon-list-alt"></i>
						<h3> <?= $leaderboardName; ?></h3>
					</div>
					<div class="widget-content">
						<table class="table table-bordered table-striped table-hover scores"  id="paginated">
							<thead class="thead-inverse">
                                <tr>
                                    <th><?= $lang['player_rank']; ?></th>
									<?php if($user_home->is_logged_in()) { ?>
										<th><?= $lang['player_id']; ?></th>
									<?php } ?>
                                    <th><?= $lang['player_name']; ?></th>
                                    <th><?= $lang['score']; ?></th>
                                    <th><?= $lang['score_date']; ?></th>
									<?php if($user_home->is_logged_in()) { ?>
										<th></th>
									<?php } ?>
                                </tr>
							</thead>
							<tbody>
							<?php if(count($leaderboardScores["scores"])==0) {
								if($user_home->is_logged_in()) {
									echo '<tr><td colspan="6" id="no_score"><div class="alert alert-danger">'.$lang["no_score"].'</div></td></tr>';
								} else {
									echo '<tr><td colspan="4" id="no_score"><div class="alert alert-danger">'.$lang["no_score"].'</div></td></tr>';
								}
							} ?>
                  <?php foreach ($leaderboardScores["scores"] as $score) : ?>
                            <tr id="row<?php echo $score['userID'];?>">
								<td colspan="1" id="no_score"></td>
								<?php if($user_home->is_logged_in()) { ?>
									<td><?= $score["userID"]; ?></td>
								<?php } ?>
                                <td id="name_val<?= $score['userID']; ?>"><?= $score["name"]; ?></td>
                                <td id="score_val<?= $score['userID']; ?>"><?= $score["score"]; ?></td>
                                <td><?= $score["date"]; ?></td>
								<?php if($user_home->is_logged_in()) { ?>
									<td>
									<button type='button' class="btn btn-primary btn-sm" id="edit_button<?= $score['userID']; ?>" onclick="edit_score('<?= $score['userID']; ?>');"><i class="icon-edit"></i>&nbsp;&nbsp;<?= $lang['edit']; ?></button>
									<button type='button' class="btn btn-success btn-sm" style="display: none; margin-left: 3px;" id="save_button<?= $score['userID']; ?>" onclick="save_score('<?= $score['userID']; ?>', '<?= $leaderboardID; ?>', '<?= $leaderboardToken; ?>', '<?= $language; ?>');"><i class="icon-save"></i>&nbsp;&nbsp;<?= $lang['save']; ?></button>
									<button type='button' class="btn btn-danger btn-sm" id="delete_button<?php echo $score['userID'];?>" onclick="delete_score('<?php echo $score['userID'];?>', '<?= $leaderboardID; ?>', '<?= $leaderboardToken; ?>', '<?= $language; ?>');"><i class="icon-trash"></i>&nbsp;&nbsp;<?= $lang['delete']; ?></button>
									</td>
								<?php } ?>
                            </tr>
                        <?php endforeach; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
	  </div>
<?php include_once('footer.php'); ?>